/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgPropertiesDialog;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMCustomObjectAttachment;
import filenet.vw.idm.trident.VWIDMDocumentAttachment;
import filenet.vw.idm.trident.VWIDMFolderAttachment;
import filenet.vw.idm.trident.VWIDMStoredSearchAttachment;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWTridentFactory;
import java.awt.Frame;
import java.util.StringTokenizer;

public class VWIDMTridentAttachment {
    IVWIDMItem m_item = null;
    String m_id = null;
    String m_lib = null;
    String m_libName = null;
    int m_libType;
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "VWIDMTridentAttachment";

    public static IVWIDMAttachment getAttachment(String path) throws VWException {
        int libType;
        int type;
        StringTokenizer stmp = new StringTokenizer(path, ":");
        String token = null;
        String library = null;
        String id = null;
        String version = null;
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                type = Integer.parseInt(token);
            }
            catch (Exception e) {
                throw new VWException("idm.trident.att.getItem2a", "{0}: Invalid type.", path);
            }
        } else {
            throw new VWException("idm.trident.att.getItem2c", "{0}: Invalid IDM Item name.", path);
        }
        if (stmp.hasMoreTokens()) {
            token = stmp.nextToken();
            try {
                libType = Integer.parseInt(token);
            }
            catch (Exception e) {
                throw new VWException("idm.trident.att.getItem2a1", "{0}: Invalid type.", path);
            }
            if (libType < 1 || libType > 2) {
                throw new VWException("idm.trident.att.getItem2b1", "{0}: Invalid type.", path);
            }
        } else {
            throw new VWException("idm.trident.att.getItem2d", "{0}: Missing library type.", path);
        }
        if (!stmp.hasMoreTokens()) {
            throw new VWException("idm.trident.att.getItem2", "{0}: Missing library name.", path);
        }
        library = stmp.nextToken();
        if (stmp.hasMoreTokens()) {
            id = stmp.nextToken();
            if (stmp.hasMoreTokens()) {
                version = stmp.nextToken();
            }
        } else {
            throw new VWException("idm.trident.att.getItem2", "{0}: Missing id.", path);
        }
        return VWIDMTridentAttachment.getItem(type, library, libType, id, version);
    }

    public static IVWIDMAttachment getItem(int type, String library, int libType, String id, String version) throws VWException {
        switch (type) {
            case 2: {
                return new VWIDMFolderAttachment(id, library, libType);
            }
            case 3: {
                return new VWIDMDocumentAttachment(id, version, library, libType);
            }
            case 4: {
                return new VWIDMStoredSearchAttachment(id, version, library, libType);
            }
            case 6: {
                return new VWIDMCustomObjectAttachment(id, library, libType);
            }
        }
        throw new VWException("idm.trident.VWIDMTridentAttachment.getItem", "Attachment Type Not Supported.");
    }

    public static IVWIDMAttachment fromIVWIDMItem(IVWIDMItem item) throws VWException {
        switch (item.getType()) {
            case 2: {
                return new VWIDMFolderAttachment(item);
            }
            case 3: {
                return new VWIDMDocumentAttachment(item);
            }
            case 4: {
                return new VWIDMStoredSearchAttachment(item);
            }
            case 6: {
                return new VWIDMCustomObjectAttachment(item);
            }
        }
        throw new VWException("idm.trident.VWIDMTridentAttachment.getItem", "Attachment Type Not Supported.");
    }

    protected void init(IVWIDMItem item) {
        this.m_item = item;
        this.m_id = item.getId();
        this.m_lib = item.getLibraryId();
        this.m_libName = item.getLibraryLabel();
        this.m_libType = item.getLibraryType();
    }

    public void showPropertiesDialog() throws VWException {
        String m_method = "showPropertiesDialog";
        if (this.m_item == null) {
            logger.warning(m_className, m_method, "No IVWIDMItem!");
            return;
        }
        try {
            ((VWTridentFactory)VWIDMBaseFactory.instance()).getScope();
            ReadableMetadataObject wcmObject = ((VWIDMTridentItem)this.m_item).getBrightspireObject();
            WcmDlgPropertiesDialog dlg = new WcmDlgPropertiesDialog((Frame)null, (BaseObject)wcmObject);
            if (dlg == null) {
                throw new VWException("idm.trident.showPropertiesDialog", "Unable to retrieve the Properties Dialog");
            }
            dlg.showDialog(null);
        }
        catch (Exception e) {
            throw new VWException("idm.trident.exception", "Exception: {0}", e.getMessage());
        }
    }

    protected String getBaseURL() throws VWException {
        IVWIDMFactoryProperties factoryProperties = VWIDMBaseFactory.instance().getProperties();
        return (String)factoryProperties.getProperty("baseURL");
    }
}

